<?php

namespace Juweliere\ApiBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('juweliere_api');

        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('base_url')->end()
                ->scalarNode('client_id')->end()
                ->scalarNode('client_secret')->end()
                ->arrayNode('log')
                    ->children()
                        ->scalarNode('path')->end()
                        ->scalarNode('level')->end()
                    ->end()
                ->end()
                ->arrayNode('redis')
                    ->children()
                        ->scalarNode('host')->end()
                        ->scalarNode('port')->end()
                        ->scalarNode('db')->end()
                        ->scalarNode('pass')->end()
                        ->scalarNode('prefix')->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}