<?php

namespace Juweliere\ApiBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class JuweliereApiExtension extends Extension
{
    /**
     * @param array            $configs
     * @param ContainerBuilder $container
     *
     * @throws \Exception
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__.'/../../config')
        );
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $definition = $container->getDefinition('Juweliere\ApiBundle\Service\JuwApi');
        $definition->replaceArgument(0, $config['base_url']);
        $definition->replaceArgument(1, $config['client_id']);
        $definition->replaceArgument(2, $config['client_secret']);
        $definition->replaceArgument(3, $config['log']['path']);
        $definition->replaceArgument(4, $config['redis']['host']);
        $definition->replaceArgument(5, $config['redis']['port']);
        $definition->replaceArgument(6, $config['redis']['pass']);
        $definition->replaceArgument(7, $config['redis']['db']);
        $definition->replaceArgument(8, $config['redis']['prefix']);
        $definition->replaceArgument(9, $config['log']['level']);
    }
}
