# juweliere/api-bundle

A bundle to provide a service for handling requests toward JUW-API.

## Installation

Execute the following [composer](https://getcomposer.org/) command to add the bundle to the dependencies of your
project:

```bash
composer require juweliere/api-bundle
```

Configuration should be done automatically by Symfony Flex, if that fails for some reason you have to do it manually:

Otherwise manual configuration:

### Configure JuwelierApiBundle

```yml
# config/packages/juweliere_api.yaml

juweliere_api:
  base_url: '%env(JUWELIERE_API_BASE_URL)%'
  client_id: '%env(JUWELIERE_API_CLIENT_ID)%',
  client_secret: '%env(JUWELIERE_API_CLIENT_SECRET)%',
  log:
    path: '%kernel.logs_dir%/'
    level: info
  redis:
    host: '%env(JUWELIERE_API_REDIS_HOST)%'
    port: '%env(JUWELIERE_API_REDIS_PORT)%'
    pass: '%env(JUWELIERE_API_REDIS_PASS)%'
    db: '%env(JUWELIERE_API_REDIS_DB)%'
    prefix: '%env(JUWELIERE_API_REDIS_PREFIX)%'
```

```yml
# config/packages/dev/juweliere_api.yaml

juweliere_api:
  log:
    level: debug
```

### Create env variables

```
# .env
# For testing: https://api.test.juweliere.de
JUWELIERE_API_BASE_URL=https://api.juweliere.de 
JUWELIERE_API_CLIENT_ID=xxx
JUWELIERE_API_CLIENT_SECRET=xxx
JUWELIERE_API_REDIS_HOST=127.0.0.1
JUWELIERE_API_REDIS_PORT=6379
JUWELIERE_API_REDIS_PASS=
JUWELIERE_API_REDIS_DB=1
JUWELIERE_API_REDIS_PREFIX="xxx:juwapi:"
```

## Usage
A service `JuwApi` is available now and be used e.g. in a controller:
```injectablephp
...

/**
 * @Route("/api/juw/test", name="juw-api-test", options={"expose"=true})
 */
public function orders(Request $request, \Juweliere\ApiBundle\Service\JuwApi $juwApi)
{
    $orders = $juwApi->orders->getAll();
    
...
    