<?php


namespace Juweliere\CheckoutBundle\Checkout\Order;


class Address
{
    private string $street;
    private string $postcode;
    private string $city;
    private string $country;
    /**
     * @var null
     */
    private $state;
    /**
     * @var null
     */
    private $street2;

    /**
     * Address constructor.
     * @param string $street
     * @param string $postcode
     * @param string $city
     * @param string $country
     * @param null $state
     * @param null $street2
     */
    public function __construct($street, $postcode, $city, $country, $state = null, $street2 = null) {

        $this->street = $street;
        $this->postcode = $postcode;
        $this->city = $city;
        $this->country = $country;
        $this->state = $state;
        $this->street2 = $street2;
    }

    /**
     * @return string
     */
    public function getStreet(): string
    {
        return $this->street;
    }

    /**
     * @param string $street
     */
    public function setStreet(string $street): void
    {
        $this->street = $street;
    }

    /**
     * @return string
     */
    public function getPostcode(): string
    {
        return $this->postcode;
    }

    /**
     * @param string $postcode
     */
    public function setPostcode(string $postcode): void
    {
        $this->postcode = $postcode;
    }

    /**
     * @return string
     */
    public function getCity(): string
    {
        return $this->city;
    }

    /**
     * @param string $city
     */
    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getCountry(): string
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(string $country): void
    {
        $this->country = $country;
    }

    /**
     * @return null
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * @param null $state
     */
    public function setState($state): void
    {
        $this->state = $state;
    }

    /**
     * @return null
     */
    public function getStreet2()
    {
        return $this->street2;
    }

    /**
     * @param null $street2
     */
    public function setStreet2($street2): void
    {
        $this->street2 = $street2;
    }
}