<?php


namespace Juweliere\CheckoutBundle\Checkout\Order;


class Order
{
    private int $id;
    private User $user;
    private Address $shipping;
    private array $items;
    private ?Address $billing;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return User
     */
    public function getUser(): User
    {
        return $this->user;
    }

    /**
     * @param User $user
     */
    public function setUser(User $user): void
    {
        $this->user = $user;
    }

    /**
     * @return Address
     */
    public function getShipping(): Address
    {
        return $this->shipping;
    }

    /**
     * @param Address $shipping
     */
    public function setShipping(Address $shipping): void
    {
        $this->shipping = $shipping;
    }

    /**
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @param array $items
     */
    public function setItems(array $items): void
    {
        $this->items = $items;
    }

    /**
     * @param Item $newItem
     * @return bool
     */
    public function addItem(Item $newItem): bool
    {
        if (!empty($this->items)) {
            foreach ($this->items as $key => $item) {
                if ($item->getSku() === $newItem->getSku()) {
                    $this->items[$key] = $newItem;

                    return true;
                }
            }
        }

        $this->items[] = $newItem;

        return true;
    }

    /**
     * @param Item $newItem
     * @return bool
     */
    public
    function removeItemBySku($sku): bool
    {
        /** @var Item $item */
        foreach ($this->items as $key => $item) {
            if ($item->getSku() === $sku) {
                array_splice($this->items, $key, 1);
                break;
            }
        }

        return true;
    }

    /**
     * @return Address|null
     */
    public function getBilling(): ?Address
    {
        return $this->billing;
    }

    /**
     * @param Address|null $billing
     */
    public
    function setBilling(?Address $billing): void
    {
        $this->billing = $billing;
    }

    /**
     * @param int $id
     */
    public
    function setId(int $id): void
    {
        $this->id = $id;
    }
}