<?php


namespace Juweliere\CheckoutBundle\Checkout;


use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\JuwApiClient\Entity\Order\Address;
use Juweliere\JuwApiClient\Entity\Order\User;
use Psr\Http\Message\RequestInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

class SessionHandler
{
    private SessionInterface $session;

    const SESSION_CHECKOUT_ORDER = "checkout.order";

    private ProductDataProvider $productDataProvider;

    /**
     * SessionHandler constructor.
     * @param SessionInterface $session
     */
    public function __construct(SessionInterface $session, ProductDataProvider $productDataProvider) {
        $this->session = $session;
        $this->productDataProvider = $productDataProvider;
    }

    public function addItemToOrder($sku, $quantity = 1) {

        /** @var array $product */
        $product = $this->productDataProvider->getProductBySku($sku);

        $order = new \Juweliere\JuwApiClient\Entity\Order\Order();

        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);
        }

        $item = new \Juweliere\JuwApiClient\Entity\Order\Item();

        $item->setSku($sku);
        $item->setName($product["name"]);
        $item->setShortDescription($product["shortDescription"]);
        $item->setPrice($product["price"]);
        $item->setQuantity($quantity);
        $item->setImages($product["images"]);
        $item->setImage($product["images"][0]);

        $order->addItem($item);

        $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
        $this->session->save();

        return true;
    }

    public function updateUserData(Request $request)
    {
        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);

            $user = new User();

            $user->setGender($request->get("gender"));
            $user->setFirstName($request->get("firstName"));
            $user->setLastName($request->get("lastName"));
            $user->setEmail($request->get("email"));

            $shippingAddress = new Address();

            $shippingAddress->setStreet($request->get("street"));
            $shippingAddress->setStreet2($request->get("street2"));
            $shippingAddress->setCity($request->get("city"));
            $shippingAddress->setState($request->get("state"));
            $shippingAddress->setCountry($request->get("country"));
            $shippingAddress->setPostcode($request->get("postcode"));

            $order->setUser($user);
            $order->setShippingAddress($shippingAddress);

            $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
        }
    }

    /**
     * @return \Juweliere\JuwApiClient\Entity\Order\Order
     */
    public function getOrder() {
        return $this->session->get(self::SESSION_CHECKOUT_ORDER);
    }
}