<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\CheckoutBundle\Entity\OrderStripe;
use Juweliere\JuwApiClient\Constants;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;
use Stripe\Checkout\Session;
use Stripe\PaymentIntent;
use Stripe\Stripe;

class StripeHandler
{
    private EntityManagerInterface $entityManager;
    private JuwApi $juwApi;
    private OrderHandler $orderHandler;

    /**
     * StripeHandler constructor.
     * @param EntityManagerInterface $entityManager
     * @param OrderHandler $orderHandler
     */
    public function __construct(EntityManagerInterface $entityManager, OrderHandler $orderHandler, JuwApi $juwApi)
    {
        $this->entityManager = $entityManager;
        $this->orderHandler = $orderHandler;
        $this->juwApi = $juwApi;
    }

    public function createCheckoutSession(array $product)
    {
        $order = new \Juweliere\JuwApiClient\Entity\Order\Order();

        $item = new \Juweliere\JuwApiClient\Entity\Order\Item();

        $payment = new Payment();

        $item->setSku($product["sku"]);
        $item->setName($product["name"]);
        $item->setImages($product["images"]);
        $item->setQuantity(1);
        $item->setPrice($product["price"]);
        $item->setShortDescription($product["shortDescription"]);

        $payment->setType(JuwApi::PAYMENT_TYPE_STRIPE_CS);
        $payment->setAmount($product["price"]);

        $order->addItem($item);
        $order->setPayment($payment);

        $result = $this->juwApi->orders->create($order);

        return $result->getLastPayment()->getExternalId();
    }

    /**
     * @param array $sessionBasket
     * @return string
     * @throws \Stripe\Exception\ApiErrorException
     */
    public function createPaymentIntent(\Juweliere\JuwApiClient\Entity\Order\Order $order)
    {
        /** @var Payment $payment */
        $payment = new Payment();

        $payment->setType(JuwApi::PAYMENT_TYPE_STRIPE);
        $payment->setAmount($order->getAmount());

        $order->setPayment($payment);

        /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
        $order = $this->juwApi->create($order);

        return $order->getLastPayment()->getClientSecret();
    }
}