<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Juweliere\ProductBundle\ElasticSearch\ElasticProductsParser;
use Juweliere\ProductBundle\Service\ProductPriceHelper;

class ProductDataProvider
{
    private ElasticProductsParser $productsParser;
    private ProductPriceHelper $priceHelper;
    private string $imageBaseUrl;

    /**
     * ProductDataProvider constructor.
     * @param ElasticProductsParser $productsParser
     * @param ProductPriceHelper $priceHelper
     * @param string $imageBaseUrl
     */
    public function __construct(
        ElasticProductsParser $productsParser,
        ProductPriceHelper $priceHelper,
        string $imageBaseUrl
    )
    {
        $this->productsParser = $productsParser;
        $this->priceHelper = $priceHelper;
        $this->imageBaseUrl = $imageBaseUrl;
    }

    /**
     * @param $sku
     * @return array|null
     * @throws \Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface
     * @throws \Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface
     */
    public function getProductBySku($sku)
    {
        $product = $this->productsParser->getSingleProduct($sku);
        $product["images"] = $this->getFullPathImages($product);
        $product["price"] = $this->getPrice($product);

        return $product;
    }

    /**
     * @param array $product
     * @return float|int
     * @throws \Exception
     */
    private function getPrice(array $product) {

        $priceData = $this->priceHelper->getPrice($product);

        if (empty($price)) {
            $price = $priceData["rrp"]["value"] * 100;

            if ($priceData["specialPrice"]) {
                $price = $priceData["rrp"]["actualPrice"] * 100;
            }
        }

        return $price;
    }

    /**
     * @param array $product
     * @return array
     */
    private function getFullPathImages(array $product, $dimension = "250x250")
    {
        /** @var array $images */
        $images = array();

        if (!empty($product["gallery"])) {
            foreach ($product["gallery"] as $image) {
                $images[] = $this->imageBaseUrl . $dimension . "/" . $image["path"];
            }
        } else {
            $images[] = $this->imageBaseUrl . $dimension . "/" . $product["image"];
        }

        return $images;
    }
}