<?php


namespace Juweliere\CheckoutBundle\Checkout;


use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\JuwApiClient\Entity\Order\Address;
use Juweliere\JuwApiClient\Entity\Order\User;
use Psr\Http\Message\RequestInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Security\Core\User\UserInterface;

class SessionHandler
{
    private SessionInterface $session;

    const SESSION_CHECKOUT_ORDER = "checkout.order";

    private ProductDataProvider $productDataProvider;

    /**
     * SessionHandler constructor.
     * @param SessionInterface $session
     */
    public function __construct(SessionInterface $session, ProductDataProvider $productDataProvider) {
        $this->session = $session;
        $this->productDataProvider = $productDataProvider;
    }

    public function addItemToOrder($sku, $quantity = 1) {

        /** @var array $product */
        $product = $this->productDataProvider->getProductBySku($sku);

        $order = new \Juweliere\JuwApiClient\Entity\Order\Order();

        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);
        }

        $item = new \Juweliere\JuwApiClient\Entity\Order\Item();

        $item->setSku($sku);
        $item->setName($product["name"]);
        $item->setShortDescription($product["shortDescription"]);
        $item->setPrice($product["price"]);
        $item->setQuantity($quantity);
        $item->setImages($product["images"]);
        $item->setImage($product["images"][0]);

        $order->addItem($item);

        $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
        $this->session->save();

        return true;
    }

    public function removeItemFromOrder($sku) {

        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            /**
             * @var \Juweliere\JuwApiClient\Entity\Order\Order;
             */
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);
            $order->removeItem($sku);

            $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
            $this->session->save();
        }
        return true;
    }

    public function updateUserData(Request $request, UserInterface $sessionUser = null)
    {
        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);

            $user = new \Juweliere\JuwApiClient\Entity\User();

            if ($sessionUser) {
                $user->setId($sessionUser->getId());
            }

            $user->setGender($request->get("gender"));
            $user->setFirstName($request->get("firstName"));
            $user->setLastName($request->get("lastName"));
            $user->setEmail($request->get("email"));

            $order->setUser($user);

            $shippingAddress = new \Juweliere\JuwApiClient\Entity\Address();


            $shippingAddress->setGender($request->get("gender"));
            $shippingAddress->setFirstName($request->get("firstName"));
            $shippingAddress->setLastName($request->get("lastName"));
            $shippingAddress->setStreet($request->get("street"));
            $shippingAddress->setStreet2($request->get("street2"));
            $shippingAddress->setCity($request->get("city"));
            $shippingAddress->setState($request->get("state"));
            $shippingAddress->setCountry($request->get("country"));
            $shippingAddress->setPostcode($request->get("postcode"));

            $order->setShippingAddress($shippingAddress);

            if ($request->get("billing_street")) {
                $billingAddress = new \Juweliere\JuwApiClient\Entity\Address();

                $billingAddress->setGender($request->get("billing_gender"));
                $billingAddress->setFirstName($request->get("billing_firstName"));
                $billingAddress->setLastName($request->get("billing_lastName"));
                $billingAddress->setStreet($request->get("billing_street"));
                $billingAddress->setStreet2($request->get("billing_street2"));
                $billingAddress->setCity($request->get("billing_city"));
                $billingAddress->setState($request->get("billing_state"));
                $billingAddress->setCountry($request->get("billing_country"));
                $billingAddress->setPostcode($request->get("billing_postcode"));

                $order->setBillingAddress($billingAddress);
            }

            $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
        }
    }

    public function unsetOrder() {
        $this->session->remove(self::SESSION_CHECKOUT_ORDER);
    }

    /**
     * @return \Juweliere\JuwApiClient\Entity\Order\Order
     */
    public function getOrder() {
        return $this->session->get(self::SESSION_CHECKOUT_ORDER);
    }
}
