<?php


namespace Juweliere\CheckoutBundle\Checkout;


use Juweliere\JuwApiClient\Entity\Order\Item;
use Juweliere\JuwApiClient\Entity\Order\Order;

class TrackingDataProvider
{
    public function getPurchaseData(Order $order) {
        /** @var \DateTime $date */
        $date = new \DateTime();

        /** @var array $trackingProducts */
        $trackingProducts = array();

        /** @var int $revenue */
        $revenue = 0;

        $tracking = array(
            "orderId" => $order->getId(),
            "shipping" => 0
        );


        /** @var Item $item */
        foreach ($order->getItems() as $item) {
            $trackingProducts[] = array(
                'id' => $item->getSku(),
                'quantity' => $item->getQuantity()
            );
            $revenue += $item->getPrice();
        }

        $revenue = $revenue / 100;
        $tax = $revenue * 0.19;

        $tracking["revenue"] = $revenue;
        $tracking["tax"] = $tax;
        $tracking["products"] = $trackingProducts;


        $date->modify('+7 day');
        $tracking["deliveryDate"] = $date->format('Y-m-d');

        return $tracking;
    }
}