<?php

namespace Juweliere\CheckoutBundle\Handler;

use Juweliere\CheckoutBundle\Constants;
use Psr\Log\LoggerInterface;

class WebhookHandler
{
    private \Juweliere\CheckoutBundle\Checkout\Mailer $mailer;
    private LoggerInterface $logger;

    public function __construct(
        \Juweliere\CheckoutBundle\Checkout\Mailer $mailer,
        LoggerInterface $logger
    ) {
        $this->mailer = $mailer;
        $this->logger = $logger;
    }

    public function mail($order, $disclaimerFile)
    {
        switch ($order["status"]) {
            case Constants::ORDER_STATUS_REFUNDED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    "Rückerstattung",
                    "refund"
                );
                break;

            case Constants::ORDER_STATUS_RETURNED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    "Rücksendung",
                    "return"
                );
                break;

            case Constants::ORDER_STATUS_PAYMENT_SUCCEEDED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    "Bestellbestätigung",
                    "confirmation",
                    $disclaimerFile
                );

                $this->mailer->sendCheckoutOrder(
                    $order["id"],
                    $order,
                    $disclaimerFile
                );

                break;

            case Constants::ORDER_STATUS_SHIPPED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    "Versand Ihrer Bestellung",
                    "shipped"
                );

                break;
        }
    }
}
