<?php

namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

trait PaymentHandlerTrait
{

    private EntityManagerInterface $entityManager;
    private JuwApi $juwApi;
    private OrderHandler $orderHandler;
    private SessionInterface $session;

    /**
     * StripeHandler constructor.
     * @param EntityManagerInterface $entityManager
     * @param OrderHandler $orderHandler
     */
    public function __construct(
        EntityManagerInterface $entityManager,
        OrderHandler $orderHandler,
        JuwApi $juwApi,
        SessionInterface $session
    )
    {
        $this->entityManager = $entityManager;
        $this->orderHandler = $orderHandler;
        $this->juwApi = $juwApi;
        $this->session = $session;
    }
}
