<?php


namespace Juweliere\CheckoutBundle\Checkout;


use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\JuwApiClient\Entity\Order\Address;
use Juweliere\JuwApiClient\Entity\Order\User;
use Psr\Http\Message\RequestInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Security\Core\User\UserInterface;

class SessionHandler
{
    private SessionInterface $session;

    const SESSION_LOGIN_REDIRECT = "loginRedirect";
    const SESSION_CHECKOUT_ORDER = "checkout.order";

    private ProductDataProvider $productDataProvider;

    /**
     * SessionHandler constructor.
     * @param SessionInterface $session
     */
    public function __construct(SessionInterface $session, ProductDataProvider $productDataProvider) {
        $this->session = $session;
        $this->productDataProvider = $productDataProvider;
    }
    public function setLoginRedirect($uri) {
        $this->session->set(self::SESSION_LOGIN_REDIRECT, $uri);
    }

    public function addItemToOrder($sku, $quantity = 1) {

        /** @var array $product */
        $product = $this->productDataProvider->getProductBySku($sku);

        $order = new \Juweliere\JuwApiClient\Entity\Order\Order();

        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);
        }

        $item = new \Juweliere\JuwApiClient\Entity\Order\Item();

        $item->setSku($sku);
        $item->setName($product["name"]);
        $item->setShortDescription($product["shortDescription"]);
        $item->setPrice($product["price"]);
        $item->setQuantity($quantity);
        $item->setImages($product["images"]);
        $item->setImage($product["images"][0]);
        $item->setReference($product["reference"]);
        $item->setBrand($product["brand"]);

        $order->addItem($item);

        $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
        $this->session->save();

        return true;
    }

    public function removeItemFromOrder($sku) {

        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            /**
             * @var \Juweliere\JuwApiClient\Entity\Order\Order;
             */
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);
            $order->removeItem($sku);

            $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
            $this->session->save();
        }
        return true;
    }

    public function setOrderId($id) {
        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);
            $order->setId($id);
            $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
        }
    }

    public function updateUserData(Request $request, UserInterface $sessionUser = null)
    {
        if ($this->session->has(self::SESSION_CHECKOUT_ORDER)) {
            /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
            $order = $this->session->get(self::SESSION_CHECKOUT_ORDER);

            $user = new \Juweliere\JuwApiClient\Entity\User();

            if ($sessionUser) {
                $user->setId($sessionUser->getId());
            }

            $user->setGender($request->get("billing_gender"));
            $user->setFirstName($request->get("billing_firstName"));
            $user->setLastName($request->get("billing_lastName"));
            $user->setEmail($request->get("email"));

            $order->setUser($user);

            $billingAddress = new \Juweliere\JuwApiClient\Entity\Address();

            $billingAddress->setGender($request->get("billing_gender"));
            $billingAddress->setFirstName($request->get("billing_firstName"));
            $billingAddress->setLastName($request->get("billing_lastName"));
            $billingAddress->setStreet($request->get("billing_street"));
            $billingAddress->setStreet2($request->get("billing_street2"));
            $billingAddress->setCity($request->get("billing_city"));
            $billingAddress->setState($request->get("billing_state"));
            $billingAddress->setCountry($request->get("billing_country"));
            $billingAddress->setPostcode($request->get("billing_postcode"));

            $order->setBillingAddress($billingAddress);

            $pickupInStore = boolval($request->get("pickupInStore"));

            $order->setPickupInStore($pickupInStore);
            $order->setShippingAddress($billingAddress);

            if (boolval($request->get("shippingAddress")) === true) {
                $shippingAddress = new \Juweliere\JuwApiClient\Entity\Address();

                $shippingAddress->setGender($request->get("shipping_gender"));
                $shippingAddress->setFirstName($request->get("shipping_firstName"));
                $shippingAddress->setLastName($request->get("shipping_lastName"));
                $shippingAddress->setStreet($request->get("shipping_street"));
                $shippingAddress->setStreet2($request->get("shipping_street2"));
                $shippingAddress->setCity($request->get("shipping_city"));
                $shippingAddress->setState($request->get("shipping_state"));
                $shippingAddress->setCountry($request->get("shipping_country"));
                $shippingAddress->setPostcode($request->get("shipping_postcode"));

                $order->setShippingAddress($shippingAddress);
            } elseif ($pickupInStore) {
                $order->setShippingAddress(null);
            }

            /*echo "<pre>";
            var_dump($order);
            echo "</pre>";
            die();*/


            $this->session->set(self::SESSION_CHECKOUT_ORDER, $order);
        }
    }

    public function unsetOrder() {
        $this->session->remove(self::SESSION_CHECKOUT_ORDER);
    }

    /**
     * @return \Juweliere\JuwApiClient\Entity\Order\Order
     */
    public function getOrder() {
        return $this->session->get(self::SESSION_CHECKOUT_ORDER);
    }
}
