# juweliere/checkout-bundle

A bundle to provide endpoints and services for handling checkouts via JUW-API.

## Installation

Execute the following [composer](https://getcomposer.org/) command to add the bundle to the dependencies of your
project:

```bash
composer require juweliere/checkout-bundle
```

Configuration should be done automatically by Symfony Flex, if that fails for some reason you have to do it manually:

### Configure JuweliereCheckoutBundle

```yml
# config/packages/juweliere_checkout.yaml

juweliere_checkout:
  mail:
    from: '%env(JUWELIERE_CHECKOUT_MAIL_FROM)%'
    from_name: '%env(JUWELIERE_CHECKOUT_MAIL_FROM_NAME)%'
    to: '%env(JUWELIERE_CHECKOUT_MAIL_TO)%'
  base_url:
    image: '%env(JUWELIERE_CHECKOUT_BASE_URL_IMAGE)%'
    product: '%env(JUWELIERE_CHECKOUT_IMAGE_BASE_URL_PRODUCT)%'
```

```yml
# config/packages/routes/juweliere_checkout.yaml

juweliere_checkout:
  resource: "@JuweliereCheckoutBundle"
  type: annotation
```

### Create env variables

```
# .env
JUWELIERE_CHECKOUT_MAIL_FROM=shop@best-jeweller-in-town.com
JUWELIERE_CHECKOUT_MAIL_FROM_NAME="Best Jeweller in Town"
JUWELIERE_CHECKOUT_MAIL_TO=orders@best-jeweller-in-town.com
JUWELIERE_CHECKOUT_BASE_URL_IMAGE=https://cdn.best-jeweller-in-town.com/
JUWELIERE_CHECKOUT_BASE_URL_PRODUCT=https://www.best-jeweller-in-town.com/products/
```

### Add required bundles to AbstractKernel

These bundles need to be registered:

```php		
/* config/bundles.php */
       	
Juweliere\ProductBundle\JuweliereProductBundle::class => ['all' => true],
Juweliere\ApiBundle\JuweliereApiBundle::class => ['all' => true],
Juweliere\CheckoutBundle\JuweliereCheckoutBundle::class => ['all' => true],
```

## Usage

### Routes
Bundle provides different routes (prefixed with `/checkout`). See `src/Controller/CheckoutController`

### Templates
Bundle templates can be overwritten within `$project_root/templates/bundles/JuweliereCheckoutBundle`.

E.g. to customize the mail header copy the header.html.twig from `$project_root/vendor/juweliere/checkout-bundle/templates/mail/checkout/snippets/header.twig.html` to the main templates folder in samte structure:

![Kiku](docs/images/customtemplate.png)
    