<?php

namespace Juweliere\CheckoutBundle\Handler;

use Juweliere\CheckoutBundle\Constants;
use Psr\Log\LoggerInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class WebhookHandler
{
    private \Juweliere\CheckoutBundle\Checkout\Mailer $mailer;
    private LoggerInterface $logger;
    private TranslatorInterface $translator;

    public function __construct(
        \Juweliere\CheckoutBundle\Checkout\Mailer $mailer,
        LoggerInterface $logger,
        TranslatorInterface $translator
    ) {
        $this->mailer = $mailer;
        $this->logger = $logger;
        $this->translator = $translator;
    }

    public function mail($order, $disclaimerFile)
    {
        dd();
        switch ($order["status"]) {
            case Constants::ORDER_STATUS_REFUNDED:
            case Constants::ORDER_STATUS_REFUNDED_NO_TRANSACTION:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.refund"),
                    "refund"
                );
                break;

            case Constants::ORDER_STATUS_RETURNED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.return"),
                    "return"
                );
                break;

            case Constants::ORDER_STATUS_PAYMENT_SUCCEEDED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.confirmation"),
                    "confirmation",
                    false,
                    $disclaimerFile
                );

                $this->mailer->sendCheckoutOrder(
                    $order["id"],
                    $order,
                    $disclaimerFile
                );

                break;

            case Constants::ORDER_STATUS_SHIPPED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.shipped"),
                    "shipped"
                );

                break;
        }
    }

    public function remindermail($orders) {
        $this->mailer->sendReminder($orders);
    }
}
