<?php

namespace Juweliere\CheckoutBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\FileLoader;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class JuweliereCheckoutExtension extends Extension
{
    /**
     * @param array            $configs
     * @param ContainerBuilder $container
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__.'/../../config')
        );
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $definition = $container->getDefinition('Juweliere\CheckoutBundle\Checkout\Mailer');
        $definition->replaceArgument(2, $config['mail']['from']);
        $definition->replaceArgument(3, $config['mail']['from_name']);
        $definition->replaceArgument(4, $config['mail']['to']);
        $definition->replaceArgument(5, $config['base_url']['image']);
        $definition->replaceArgument(6, $config['base_url']['product']);
        $definition->replaceArgument(7, $config['base_url']['decorator']);

        $definition = $container->getDefinition('Juweliere\CheckoutBundle\Checkout\ProductDataProvider');
        $definition->replaceArgument(2, $config['base_url']['image']);
    }
}
