<?php


namespace Juweliere\CheckoutBundle\Checkout;


use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\CheckoutBundle\Checkout\Order\User;
use Juweliere\CheckoutBundle\Entity\OrderStripe;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;
use Stripe\Checkout\Session;
use Stripe\Customer;

class OrderHandler
{
    private EntityManagerInterface $entityManager;

    /**
     * OrderHandler constructor.
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
    }

    /**
     * @param $stripeId
     * @return Order
     * @throws \Stripe\Exception\ApiErrorException
     */
    public function getByStripeCheckoutSessionId($stripeId)
    {
        \Stripe\Stripe::setApiKey($_SERVER["STRIPE_API_KEY"]);

        /** @var Session $session */
        $session = \Stripe\Checkout\Session::retrieve(
            $stripeId
        );

        /** @var Customer $customer */
        $customer = \Stripe\Customer::retrieve($session->customer);


        /** @var OrderStripe $order */
        $order = $this->entityManager
            ->getRepository(OrderStripe::class)
            ->findOneBy(array("stripe_id" => $stripeId));

        return $this->mapStripeCSToOrder($order, $customer);
    }

    /**
     * @param OrderStripe $stripeOrder
     * @param Customer $stripeCustomer
     * @return Order
     */
    private function mapStripeCSToOrder(OrderStripe $stripeOrder, Customer $stripeCustomer) {

        $orderData = json_decode($stripeOrder->getData());

        $order = new Order();

        $order->setId($stripeOrder->getId());

        foreach ($orderData->display_items as $stripeItem) {
            $item = new Item(
                $stripeItem->quantity,
                $stripeItem->name,
                $stripeItem->description,
                $stripeItem->amount,
                $stripeItem->images[0],
                $stripeItem->quantity
            );
            $order->addItem($item);
        }

        $user = new User(
            $stripeCustomer->name,
            "",
            $stripeCustomer->email
        );

        $order->setUser($user);

        return $order;

    }
}