<?php

namespace Juweliere\CheckoutBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('juweliere_checkout');

        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('mail')
                    ->children()
                        ->scalarNode('from')->end()
                        ->scalarNode('from_name')->end()
                        ->scalarNode('to')->end()
                    ->end()
                ->end() // mail
                ->arrayNode('base_url')
                    ->children()
                        ->scalarNode('image')->end()
                        ->scalarNode('product')->end()
                        ->scalarNode('decorator')->end()
                    ->end()
                ->end() // image
            ->end()
        ;

        return $treeBuilder;
    }
}
