<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\CheckoutBundle\Entity\OrderStripe;
use Juweliere\JuwApiClient\Constants;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;
use Stripe\Checkout\Session;
use Stripe\PaymentIntent;
use Stripe\Stripe;

class StripeHandler
{
    use PaymentHandlerTrait;

    public function createCheckoutSession(array $product)
    {
        $order = new \Juweliere\JuwApiClient\Entity\Order\Order();

        $item = new \Juweliere\JuwApiClient\Entity\Order\Item();

        $payment = new Payment();

        $item->setSku($product["sku"]);
        $item->setName($product["name"]);
        $item->setImages($product["images"]);
        $item->setQuantity(1);
        $item->setPrice($product["price"]);
        $item->setShortDescription($product["shortDescription"]);

        $payment->setType(JuwApi::PAYMENT_TYPE_STRIPE_CS);
        $payment->setAmount($product["price"]);

        $order->addItem($item);
        $order->setPayment($payment);

        $result = $this->juwApi->orders->create($order);

        return $result->getLastPayment()->getExternalId();
    }
}
