<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\CheckoutBundle\Entity\OrderStripe;
use Juweliere\JuwApiClient\Constants;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;
use Stripe\Checkout\Session;
use Stripe\PaymentIntent;
use Stripe\Stripe;

class PayoneHandler
{
    use PaymentHandlerTrait;

    /**
     * @param Order $order
     * @return \Juweliere\JuwApiClient\Entity\Order\Order
     * @throws \Stripe\Exception\ApiErrorException
     */
    public function createOrder(\Juweliere\JuwApiClient\Entity\Order\Order $order)
    {
        /** @var Payment $payment */
        $payment = new Payment();

        $payment->setType("PAYONE");
        $payment->setAmount($order->getAmount());

        $order->setPayment($payment);

        /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
        $order = $this->juwApi->orders->create($order);

        return $order;
    }

    public function confirmOrder(\Juweliere\JuwApiClient\Entity\Order\Order $order)
    {
        return $this->juwApi->orders->confirmPaypal($order->getId(), null);
    }
}
