<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\CheckoutBundle\Entity\OrderStripe;
use Juweliere\JuwApiClient\Constants;
use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;
use Juweliere\UserBundle\Security\UserProvider;
use Stripe\Checkout\Session;
use Stripe\PaymentIntent;
use Stripe\Stripe;

class UserHandler
{
    use PaymentHandlerTrait;

    public function addAddress(Address $address, $user)
    {
        $address->setUser($user->getId());
        $this->sessionRefreshUser();
        
        $result = $this->juwApi->addresses->add($address);

        return $result->getId();
    }

    public function sessionRefreshUser()
    {
        $this->session->set(UserProvider::SESSION_KEY_REFRESH_USER, 1);
    }
}
