<?php

namespace Juweliere\CheckoutBundle\Handler;

use Juweliere\CheckoutBundle\Constants;
use Psr\Log\LoggerInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class WebhookHandler
{
    private \Juweliere\CheckoutBundle\Checkout\Mailer $mailer;
    private LoggerInterface $logger;
    private TranslatorInterface $translator;

    public function __construct(
        \Juweliere\CheckoutBundle\Checkout\Mailer $mailer,
        LoggerInterface $logger,
        TranslatorInterface $translator
    ) {
        $this->mailer = $mailer;
        $this->logger = $logger;
        $this->translator = $translator;
    }

    public function mail($order, $disclaimerFile)
    {
        switch ($order["status"]) {
            case Constants::ORDER_STATUS_REFUNDED:
            case Constants::ORDER_STATUS_REFUNDED_NO_TRANSACTION:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.refund"),
                    "refund"
                );
                break;

            case Constants::ORDER_STATUS_RETURNED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.return"),
                    "return"
                );
                break;

            case Constants::ORDER_STATUS_PAYMENT_SUCCEEDED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.confirmation"),
                    "confirmation",
                    false,
                    $disclaimerFile
                );

                $this->mailer->sendCheckoutOrder(
                    $order["id"],
                    $order,
                    $disclaimerFile
                );

                break;

            case Constants::ORDER_STATUS_SHIPPED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.shipped"),
                    "shipped"
                );

                break;

            case Constants::ORDER_PICKED_UP:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.picked_up"),
                    "picked_up"
                );

                break;

            case Constants::ORDER_IN_PROGRESS:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.in_progress"),
                    "in_progress"
                );

                break;

            case Constants::ORDER_STATUS_CANCELED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.canceled"),
                    "canceled"
                );

                break;

            case Constants::ORDER_STATUS_RETURN_ANNOUNCED:
                $this->mailer->sendUserInfo(
                    $order["id"],
                    $order,
                    $this->translator->trans("juw.checkout.mail.subject.return_announced"),
                    "return_announced"
                );

                break;
        }
    }

    public function remindermail($orders) {
        $this->mailer->sendReminder($orders);
    }
}
