<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\CheckoutBundle\Entity\OrderStripe;
use Juweliere\JuwApiClient\Constants;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;
use Stripe\Checkout\Session;
use Stripe\PaymentIntent;
use Stripe\Stripe;

class MollieHandler
{
    use PaymentHandlerTrait;

    /**
     * @param Order $order
     * @return \Juweliere\JuwApiClient\Entity\Order\Order
     * @throws \Stripe\Exception\ApiErrorException
     */
    public function createPayment(\Juweliere\JuwApiClient\Entity\Order\Order $order, $token)
    {
        /** @var Payment $payment */
        $payment = new Payment();

        $payment->setType(JuwApi::PAYMENT_TYPE_MOLLIE);
        $payment->setAmount($order->getAmount());

        $payment->setClientSecret($token);

        $order->setPayment($payment);

        /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
        $order = $this->juwApi->orders->update($order);

        return $order;
    }
}
