<?php

namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

trait PaymentHandlerTrait
{

    private EntityManagerInterface $entityManager;
    private JuwApi $juwApi;
    private OrderHandler $orderHandler;
    private SessionInterface $session;

    /**
     * StripeHandler constructor.
     * @param EntityManagerInterface $entityManager
     * @param OrderHandler $orderHandler
     */
    public function __construct(
        EntityManagerInterface $entityManager,
        OrderHandler $orderHandler,
        JuwApi $juwApi,
        SessionInterface $session
    )
    {
        $this->entityManager = $entityManager;
        $this->orderHandler = $orderHandler;
        $this->juwApi = $juwApi;
        $this->session = $session;
    }

    /**
     * @param array $sessionBasket
     * @return \Juweliere\JuwApiClient\Entity\Order\Order
     * @throws \Stripe\Exception\ApiErrorException
     */
    public function createPaymentIntent(\Juweliere\JuwApiClient\Entity\Order\Order $order, $type = JuwApi::PAYMENT_TYPE_STRIPE, $token = null)
    {
        /** @var Payment $payment */
        $payment = new Payment();

        $payment->setType($type);
        $payment->setAmount($order->getAmount());

        if ($token) {
            $payment->setClientSecret($token);
        }

        $order->setPayment($payment);
        $order->setId(null);

        /** @var \Juweliere\JuwApiClient\Entity\Order\Order $order */
        $order = $this->juwApi->orders->create($order);

        return $order;
    }
}
