<?php

declare(strict_types=1);

namespace Juweliere\CheckoutBundle\Checkout;

use Doctrine\ORM\EntityManagerInterface;
use GuzzleHttp\Exception\GuzzleException;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;
use Symfony\Component\HttpFoundation\RequestStack;

trait PaymentHandlerTrait
{
    private EntityManagerInterface $entityManager;

    private JuwApi $juwApi;

    private OrderHandler $orderHandler;

    private RequestStack $requestStack;

    /**
     * StripeHandler constructor.
     */
    public function __construct(
        EntityManagerInterface $entityManager,
        OrderHandler $orderHandler,
        JuwApi $juwApi
    )
    {
        $this->entityManager = $entityManager;
        $this->orderHandler = $orderHandler;
        $this->juwApi = $juwApi;
    }

    /**
     *
     * @throws GuzzleException
     */
    public function createPaymentIntent(Order $order, string $type = JuwApiClient::PAYMENT_TYPE_STRIPE, $token = null): Order
    {
        $payment = new Payment();

        $payment->setType($type);
        $payment->setAmount($order->getAmount());

        if ($token) {
            $payment->setClientSecret($token);
        }

        $order->setPayment($payment);
        $order->setId(null);

        /** @var Order $order */
        $order = $this->juwApi->orders->create($order);

        return $order;
    }
}
