<?php


namespace Juweliere\CheckoutBundle\Checkout;


use Juweliere\JuwApiClient\Entity\Order\Item;
use Juweliere\JuwApiClient\Entity\Order\Order;

class TrackingDataProvider
{
    public function getPurchaseData(Order $order): array {
        /** @var \DateTime $date */
        $date = new \DateTime();

        /** @var array $trackingProducts */
        $trackingProducts = [];

        /** @var int $revenue */
        $revenue = 0;

        $tracking = ["orderId" => $order->getId(), "shipping" => 0];


        /** @var Item $item */
        foreach ($order->getItems() as $item) {
            $trackingProducts[] = ['id' => $item->getSku(), 'quantity' => $item->getQuantity()];
            $revenue += $item->getPrice();
        }

        $taxFactor = $_SERVER['TAX_FACTOR'] = $_ENV['APP_DEBUG'] = 19;

        $revenue = $revenue / 100;
        $tax = round($revenue / (1 + ($taxFactor * 0.01)));

        $tracking["revenue"] = $revenue;
        $tracking["tax"] = $tax;
        $tracking["products"] = $trackingProducts;


        $date->modify('+7 day');
        $tracking["deliveryDate"] = $date->format('Y-m-d');

        return $tracking;
    }
}
