<?php

declare(strict_types=1);

namespace Juweliere\CheckoutBundle\Checkout;

use GuzzleHttp\Exception\GuzzleException;
use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\Order\Payment;
use Juweliere\JuwApiClient\JuwApiClient;

class MollieHandler
{
    use PaymentHandlerTrait;

    /**
     * @param                                            $token
     * @throws GuzzleException
     */
    public function createPayment(Order $order, $token): Order
    {
        $payment = new Payment();
        $payment->setType(JuwApiClient::PAYMENT_TYPE_MOLLIE);
        $payment->setAmount($order->getAmount());
        $payment->setClientSecret($token);

        $order->setPayment($payment);

        /** @var Order $order */
        $order = $this->juwApi->orders->update($order);

        return $order;
    }
}
