<?php


namespace Juweliere\CheckoutBundle\Checkout\Order;


class Order
{
    private $id;

    private User $user;

    private Address $shipping;

    private array $items;

    private ?Address $billing = null;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    public function getUser(): User
    {
        return $this->user;
    }

    public function setUser(User $user): void
    {
        $this->user = $user;
    }

    public function getShipping(): Address
    {
        return $this->shipping;
    }

    public function setShipping(Address $shipping): void
    {
        $this->shipping = $shipping;
    }

    public function getItems(): array
    {
        return $this->items;
    }

    public function setItems(array $items): void
    {
        $this->items = $items;
    }

    public function addItem(Item $newItem): bool
    {
        foreach ($this->items as $key => $item) {
            if ($item->getSku() === $newItem->getSku()) {
                $this->items[$key] = $newItem;

                return true;
            }
        }

        $this->items[] = $newItem;

        return true;
    }

    /**
     * @param Item $newItem
     */
    public
    function removeItemBySku($sku): bool
    {
        /** @var Item $item */
        foreach ($this->items as $key => $item) {
            if ($item->getSku() === $sku) {
                array_splice($this->items, $key, 1);
                break;
            }
        }

        return true;
    }

    public function getBilling(): ?Address
    {
        return $this->billing;
    }

    public function setBilling(?Address $billing): void
    {
        $this->billing = $billing;
    }

    /**
     * @param $id
     */
    public function setId($id): void
    {
        $this->id = $id;
    }
}
