<?php


namespace Juweliere\CheckoutBundle\Checkout;


use Stripe\Stripe;
use Doctrine\ORM\EntityManagerInterface;
use Juweliere\CheckoutBundle\Checkout\Order\Item;
use Juweliere\CheckoutBundle\Checkout\Order\Order;
use Juweliere\CheckoutBundle\Checkout\Order\User;
use Juweliere\CheckoutBundle\Entity\OrderStripe;
use Stripe\Checkout\Session;
use Stripe\Customer;

class OrderHandler
{
    /**
     * OrderHandler constructor.
     */
    public function __construct(private readonly EntityManagerInterface $entityManager)
    {
    }

    /**
     * @param $stripeId
     * @return Order
     * @throws \Stripe\Exception\ApiErrorException
     */
    public function getByStripeCheckoutSessionId($stripeId)
    {
        Stripe::setApiKey($_SERVER["STRIPE_API_KEY"]);

        /** @var Session $session */
        $session = Session::retrieve(
            $stripeId
        );

        /** @var Customer $customer */
        $customer = Customer::retrieve($session->customer);


        /** @var OrderStripe $order */
        $order = $this->entityManager
            ->getRepository(OrderStripe::class)
            ->findOneBy(["stripe_id" => $stripeId]);

        return $this->mapStripeCSToOrder($order, $customer);
    }

    /**
     * @param Customer $stripeCustomer
     */
    private function mapStripeCSToOrder(OrderStripe $stripeOrder, Customer $stripeCustomer): Order {

        $orderData = json_decode((string) $stripeOrder->getData());

        $order = new Order();

        $order->setId($stripeOrder->getId());

        foreach ($orderData->display_items as $stripeItem) {
            $item = new Item(
                $stripeItem->quantity,
                $stripeItem->name,
                $stripeItem->description,
                $stripeItem->amount,
                $stripeItem->images[0],
                $stripeItem->quantity
            );
            $order->addItem($item);
        }

        $user = new User(
            $stripeCustomer->name,
            "",
            $stripeCustomer->email
        );

        $order->setUser($user);

        return $order;

    }
}