<?php

declare(strict_types=1);

namespace Juweliere\CheckoutBundle\Checkout;

use GuzzleHttp\Exception\GuzzleException;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\Order\Payment;

class PaypalHandler
{
    use PaymentHandlerTrait;

    /**
     * @throws GuzzleException
     */
    public function createOrder(Order $order): Order
    {
        $payment = new Payment();
        $payment->setType(JuwApi::PAYMENT_TYPE_PAYPAL);
        $payment->setAmount($order->getAmount());

        $order->setPayment($payment);

        /** @var Order $order */
        $order = $this->juwApi->orders->update($order);

        return $order;
    }

    public function confirmOrder(Order $order, $payerId)
    {
        return $this->juwApi->orders->confirmPaypal($order->getId(), $payerId);
    }
}
