<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\Order\Item;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\JuwApiClient\Entity\Order\Payment;

class StripeHandler
{
    use PaymentHandlerTrait;

    public function createCheckoutSession(array $product)
    {
        $order = new Order();

        $item = new Item();

        $payment = new Payment();

        $item->setSku($product["sku"]);
        $item->setName($product["name"]);
        $item->setImages($product["images"]);
        $item->setQuantity(1);
        $item->setPrice($product["price"]);
        $item->setShortDescription($product["shortDescription"]);

        $payment->setType(JuwApi::PAYMENT_TYPE_STRIPE_CS);
        $payment->setAmount($product["price"]);

        $order->addItem($item);
        $order->setPayment($payment);

        $result = $this->juwApi->orders->create($order);

        return $result->getLastPayment()->getExternalId();
    }
}
