<?php


namespace Juweliere\CheckoutBundle\Checkout;

use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\UserBundle\Security\UserProvider;

class UserHandler
{
    use PaymentHandlerTrait;

    public function addAddress(Address $address, $user): ?string
    {
        $address->setUser($user->getId());
        $this->sessionRefreshUser();
        
        $result = $this->juwApi->addresses->add($address);

        return $result->getId();
    }

    public function sessionRefreshUser(): void
    {
        $this->session->set(UserProvider::SESSION_KEY_REFRESH_USER, 1);
    }
}
