<?php

namespace Juweliere\CheckoutBundle\Entity;

use Gedmo\Timestampable\Traits\TimestampableEntity;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'juweliere_order_stripe')]
#[ORM\Entity(repositoryClass: Juweliere\CheckoutBundle\Repository\OrderStripeRepository::class)]
class OrderStripe
{
    use TimestampableEntity;
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer')]
    private $id;

    #[ORM\Column(type: 'string', length: 255)]
    private ?string $stripe_id = null;

    #[ORM\Column(type: 'string', length: 90)]
    private ?string $sku = null;

    #[ORM\Column(type: 'string', length: 90, nullable: true)]
    private $reference;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $data = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStripeId(): ?string
    {
        return $this->stripe_id;
    }

    public function setStripeId(string $stripe_id): self
    {
        $this->stripe_id = $stripe_id;

        return $this;
    }

    public function getSku(): ?string
    {
        return $this->sku;
    }

    public function setSku(string $sku): self
    {
        $this->sku = $sku;

        return $this;
    }

    public function getData(): ?string
    {
        return $this->data;
    }

    public function setData(?string $data): self
    {
        $this->data = $data;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getReference()
    {
        return $this->reference;
    }

    public function setReference(mixed $reference): void
    {
        $this->reference = $reference;
    }
}
