<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('juweliere_core');
        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('decorator')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->scalarNode('base_url')
                            ->info('Basis-URL des Online-Dekorateurs')
                            ->isRequired()
                            ->cannotBeEmpty()
                        ->end()
                    ->end()
                ->end()

//                ->arrayNode('contact')
//                    ->addDefaultsIfNotSet()
//                        ->children()
//                            ->scalarNode('email')
//                                ->info('E-Mail-Adresse z.B. zur Produktanfrage')
//                                ->defaultValue('admin@juweliere.de')
//                                ->isRequired()
//                                ->cannotBeEmpty()
//                            ->end()
//                        ->end()
//                        ->children()
//                            ->scalarNode('phone')
//                                ->info('Telefonnummer z.B. zur Produktanfrage')
//                                ->defaultValue('+49 251 93205590')
//                                ->isRequired()
//                                ->cannotBeEmpty()
//                            ->end()
//                        ->end()
//                    ->end()
//                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
