<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Session;

final class CatalogFilterManager extends SessionManager
{
    /**
     * @param $uuid
     * @param $filter
     */
    public function addFilter($uuid, $filter): void
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            if (isset($entry['filters'])) {
                if (!in_array($filter['code'], $entry['filters'])) {
                    $key = $filter['code'];
                    $value = $filter['value'];

                    $entry['filters'][$key] = $value;

                    $this->session->set($uuid, $entry);
                }
            } else {
                $key = $filter['code'];
                $value = $filter['value'];

                $entry['filters'][$key] = $value;

                $this->session->set($uuid, $entry);
            }
        } else {
            $key = $filter['code'];
            $value = $filter['value'];

            $entry['filters'][$key] = $value;

            $this->session->set($uuid, $entry);
        }
    }

    /**
     * @param $uuid
     * @param $filter
     */
    public function removeFilter($uuid, $filter): void
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            if (isset($entry['filters'])) {
                if (key_exists($filter, $entry['filters'])) {
                    unset($entry['filters'][$filter]);
                }

                $this->session->set($uuid, $entry);
            }
        }
    }

    /**
     * @param $uuid
     *
     * @return bool
     */
    public function removeEntry($uuid): bool
    {
        $entry = $this->getEntry($uuid);

        if ($entry) {
            foreach ($entry['filters'] as $key => $filter) {
                unset($entry['filters'][$key]);
            }

            $this->session->set($uuid, $entry);

            return true;
        }

        return false;
    }
}
