<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class ProductMetaExtension extends AbstractExtension
{
    public function getFunctions(): array
    {
        return [
            new TwigFunction('product_meta_title', [$this, 'getProductMetaTitle']),
            new TwigFunction('product_meta_description', [$this, 'getProductMetaDescription']),
        ];
    }

    public function getProductMetaTitle(string $name, string $brand, string $reference, bool $isSaleable = false): string
    {
        $title = sprintf('%s %s %s online entdecken', $brand, $name, $reference);
        if ($isSaleable) {
            $title = sprintf('%s %s %s online kaufen', $brand, $name, $reference);
        }


        if (strlen($title) > 70) {
            $title = sprintf('%s %s %s', $brand, $name, $reference);
        } elseif (strlen($title) < 50) {
            $title = sprintf('%s %s %s | ', $brand, $name, $reference);
        }

        return $title;
    }

    public function getProductMetaDescription(string $name, string $brand, bool $isSaleable = false): string
    {
        $description = sprintf('%s %s ✓Autorisierter Händler ✓Meisterwerkstatt', $brand, $name);

        if ($isSaleable) {
            $description = sprintf('%s %s sicher online kaufen. ✓Autorisierter Händler ✓0 € Versandkosten ✓Sicherer Wertversand ✓Meisterwerkstatt ', $brand, $name);
        }

        return $description;
    }
}
