<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Session;

use Symfony\Component\HttpFoundation\Session\SessionInterface;

class SessionManager
{
    protected SessionInterface $session;

    public function __construct(SessionInterface $session)
    {
        $this->session = $session;
    }

    /**
     * @param string $uuid
     * @param int $page
     */
    public function setPage(string $uuid, int $page): void
    {
        $entry = $this->getEntry($uuid);

        $entry['page'] = $page;
        $this->session->set($uuid, $entry);
    }

    /**
     * @param string $uuid
     * @param int $limit
     */
    public function setLimit(string $uuid, int $limit): void
    {
        $entry = $this->getEntry($uuid);

        $entry['limit'] = $limit;
        $this->session->set($uuid, $entry);
    }

    /**
     * @param string $uuid
     * @param string $sorter
     * @param string $dir
     */
    public function setSorting(string $uuid, string $sorter, string $dir = 'asc'): void
    {
        $entry = $this->getEntry($uuid);

        $entry['sort'] = $sorter;
        $entry['dir'] = $dir;
        $this->session->set($uuid, $entry);
    }

    /**
     * @param $uuid
     *
     * @return array|null
     */
    public function getEntry($uuid): ?array
    {
        if ($this->session->has($uuid)) {
            return $this->session->get($uuid, []);
        }

        return null;
    }
}
