<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Controller\Website;

use Juweliere\CoreBundle\ElasticSearch\ElasticProductsParser;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\DecodingExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

class SearchController extends AbstractController
{
    private ElasticProductsParser $productsParser;

    public function __construct(ElasticProductsParser $productsParser)
    {
        $this->productsParser = $productsParser;
    }

    /**
     * @Route("/suche", name="product_search", options={"expose"=true})
     *
     * @param Request $request
     *
     * @return Response
     *
     * @throws ClientExceptionInterface
     * @throws DecodingExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     */
    public function search(Request $request)
    {
        $hits = $this->productsParser->searchProducts($request);

        return $this->render('pages/search.html.twig', [
            'result' => $hits,
        ]);
    }
}
