<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class JuweliereCoreExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.xml');

        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        array_walk(
            $config,
            array($this, 'setParameters'),
            array('parentKey' => $this->getAlias(), 'container' => $container)
        );

        foreach ($config as $key => $value) {
            $container->setParameter('juweliere_core'.$key, $value);
        }
    }

    public function setParameters($value, $key, $params): void
    {
        $parameterName = $params['parentKey'].'.'.$key;
        $params['container']->setParameter($parameterName, $value);
        if (is_array($value)) {
            array_walk($value, array($this, 'setParameters'),
                array(
                    'parentKey' => $parameterName,
                    'container' => $params['container'],
                )
            );
        }
    }

}
