<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Service;

use Carbon\Carbon;
use Exception;

final class ProductPriceHelper
{
    const PRICE_ATTRIBUTE_CODE = 'rrp';

    /**
     * @param array|null $product
     * @return array|null
     * @throws Exception
     */
    public function getPrice(?array $product): ?array
    {
        if (!$product) {
            return null;
        }

        $showPrice = (bool) $product['showPrice'];
        if (!$showPrice) {
            return null;
        }

        $rrp = isset($product[self::PRICE_ATTRIBUTE_CODE]) ? (float) $product[self::PRICE_ATTRIBUTE_CODE] : null;

        if (!$rrp) {
            return null;
        }

        $data = [
            'rrp' => [
                'value' => $rrp,
                'currency' => '€',
            ],
            'specialPrice' => null,
            'actualPrice' => [
                'value' => $rrp,
                'currency' => '€',
            ],
        ];

        $specialsPrices = isset($product['prices']) && sizeof($product['prices']) > 0 ? $product['prices'] : null;

        if ($specialsPrices) {
            foreach ($specialsPrices as $specialsPrice) {
                $validFrom = new Carbon($specialsPrice['validFrom']);
                $validThrough = new Carbon($specialsPrice['validThrough']);

                $now = Carbon::now();

                if ($validFrom->lte($now) && $validThrough->gte($now)) {
                    if ($specialsPrice['currency'] === $data['actualPrice']['currency']) {
                        $data['specialPrice'] = [
                            'value' => (float) $specialsPrice['price'],
                            'currency' => $specialsPrice['currency'],
                        ];

                        $data['actualPrice']['value'] = (float) $specialsPrice['price'];
                    }
                }
            }
        }

        return $data;
    }
}
