<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Twig;


use Symfony\Component\DependencyInjection\ContainerInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class AppExtension extends AbstractExtension
{
    private ContainerInterface $container;

    public function __construct(ContainerInterface $container)
    {

        $this->container = $container;
    }

    public function getFilters(): array
    {
        return [
            new TwigFilter('integer', [$this, 'getIntVal']),
        ];
    }
//
//    public function getFunctions(): array
//    {
//        return [
//            new TwigFilter('contact_phone', [$this, 'getContactPhone']),
//            new TwigFilter('contact_email', [$this, 'getContactEmail']),
//        ];
//    }

    public function getIntVal(?string $value): ?int
    {
        if ($value) {
            return (int) $value;
        }

        return null;
    }

//    public function getContactPhone(): ?string
//    {
//        return $this->container->getParameter('juweliere_core.contact.phone');
//    }
//
//    public function getContactEmail(): ?string
//    {
//        return $this->container->getParameter('juweliere_core.contact.email');
//    }
}
