<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Api;

use Symfony\Contracts\HttpClient\ResponseInterface;

class JuweliereApiParser
{
    private const API_PRODUCT_SELECTION_URI = '/api/juweliere-selections?order[name]=asc';
    private const API_WIDGET_SELECTION_URI = '/api/juweliere-widgets?order[name]=asc';

    private JuweliereApiClient $apiClient;

    public function __construct(JuweliereApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    public function fetchData(string $type): array
    {
        switch ($type) {
            case $type === 'selection':
                $response = $this->apiClient->get(self::API_PRODUCT_SELECTION_URI);
                break;
            case $type === 'widget':
                $response = $this->apiClient->get(self::API_WIDGET_SELECTION_URI);
                break;
        }

        if (!empty($response)) {
            if ($response->getStatusCode() >= 300) {
                return [];
            }

            $content = $this->getContent($response);

            return $this->getCollection($content);
        }

        return [];
    }

    private function getContent(ResponseInterface $response): array
    {
        $content = $response->toArray(false);

        if (!isset($content['hydra:totalItems']) || $content['hydra:totalItems'] === 0) {
            return [];
        }

        return $content;
    }

    private function getCollection(array $content): array
    {
        if (empty($content)) {
            return [];
        }
        $values = [];

        $values[] = [
            'name' => '',
            'title' => 'Bitte auswählen',
        ];
        foreach ($content['hydra:member'] as $item) {
            if (!isset($item['id']) ||!isset($item['name'])) {
                continue;
            }

            $values[] = [
                'name' => $item['id'],
                'title' => $item['name'],
            ];
        }

        return $values;
    }
}
