Installation
============

Make sure Composer is installed globally, as explained in the
[installation chapter](https://getcomposer.org/doc/00-intro.md)
of the Composer documentation.

Applications that use Symfony Flex
----------------------------------

There is no flex recipe available since this is a proprietary bundle.

Applications that don't use Symfony Flex
----------------------------------------

### Step 1: Download the Bundle

Open a command console, enter your project directory and execute the
following command to download the latest stable version of this bundle:

```console
$ composer require juweliere/core-bundle
```

### Step 2: Enable the Bundle

Then, enable the bundle by adding it to the list of registered bundles
in the `config/bundles.php` file of your project:

```php
// config/bundles.php

return [
    // ...
    Juweliere\CoreBundle\JuweliereCoreBundle::class => ['all' => true],
];
```

### Step 3: Copy configuration file

Set the base configuration of the bundle by editing and then copying `config/packages/juweliere_core.yaml` into your project's `<project-root>/config/packages` directory.

```shell script
cp vendor/Juweliere/CoreBundle/config/juweliere_core.php <project-dir>/config/packages/
```


