<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Twig;


use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class CatalogExtension extends AbstractExtension
{
    public function getFunctions(): array
    {
        return [
            new TwigFunction('catalog_next_page_url', [$this, 'getNextPageUrl']),
            new TwigFunction('catalog_prev_page_url', [$this, 'getPrevPageUrl']),
        ];
    }

    public function getNextPageUrl(string $currentUrl, int $page, int $pages): string
    {
        $currentPage = sprintf('page=%s', (string) $page);
        $nextPage = sprintf('page=%s', $page + 1);

        if ($page === $pages) {
            $nextPage = sprintf('page=%s', $page);
        }

        if (strpos($currentUrl, 'page')) {
            $url = str_replace($currentPage, $nextPage, $currentUrl);
        } else {
            $url = sprintf('%s?%s', $currentUrl, $nextPage);
        }

        return $url;
    }

    public function getPrevPageUrl(string $currentUrl, int $page): string
    {
        $currentPage = sprintf('page=%s', (string) $page);
        $nextPage = sprintf('page=%s', $page - 1);

        if (1 === $page) {
            $nextPage = sprintf('page=%s', $page);
        }

        if (strpos($currentUrl, 'page')) {
            $url = str_replace($currentPage, $nextPage, $currentUrl);
        } else {
            $url = sprintf('%s?%s', $currentUrl, $nextPage);
        }

        return $url;
    }
}
