<?php

declare(strict_types=1);

namespace Juweliere\CoreBundle\Api;

use Symfony\Component\HttpClient\HttpClient;
use Symfony\Contracts\HttpClient\HttpClientInterface;
use Symfony\Contracts\HttpClient\ResponseInterface;

class JuweliereApiClient
{
    private HttpClientInterface $httpClient;

    public function __construct(string $baseUri)
    {
        $this->httpClient = HttpClient::createForBaseUri($baseUri);
    }

    public function get(string $uri): ?ResponseInterface
    {
        return $this->httpClient->request('GET', $uri);
    }
}
