<?php


namespace Juweliere\JuwApiClient\Service;


use Juweliere\JuwApiClient\Entity\Order\Order;

class Orders
{
    use ServiceTrait;

    /**
     * @return Order[]
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getAll()
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "GET",
            $this->baseUrl . "/me/orders",
            $this->getAccessToken()
        );

        $order = new Order();

        return $this->getResponse($request, $order);
    }

    /**
     * @return Order
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function get($uuid)
    {
        $request =  $this->provider->getAuthenticatedRequest(
            "GET",
            $this->baseUrl . "/me/orders/" . $uuid,
            $this->getAccessToken()
        );

        $order = new Order();

        return $this->getResponse($request, $order);
    }

    /**
     * @param Order $order
     * @return Order
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function create(Order $order) {

        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl . "/me/orders",
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($order)
            ]
        );

        $orderResponse = new Order();

        return $this->getResponse($request, $orderResponse);
    }
}