<?php

namespace Juweliere\JuwApiClient\Entity;


class User extends AbstractEntity
{
    /** @var string */
    protected $id;

    /** @var string */
    protected $gender;

    /** @var string */
    protected $firstName;

    /** @var string */
    protected $lastName;

    /** @var string */
    protected $email;

    /** @var Address[] */
    protected $addresses;

    /** @var User\WishlistItem[] */
    protected $wishlistItems;


    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId($id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return Address[]
     */
    public function getAddresses(): ?array
    {
        return $this->addresses;
    }

    /**
     * @return Address[]
     */
    public function setAddresses(?array $addresses = null): self
    {
        $this->addresses = $addresses;

        return $this;
    }

    /**
     * @return User\WishlistItem[]
     */
    public function getWishlistItems(): ?array
    {
        return $this->wishlistItems;
    }

    /**
     * @return User\WishlistItem[]
     */
    public function setWishlistItems(?array $wishlistItems = null): self
    {
        $this->wishlistItems = $wishlistItems;

        return $this;
    }
}
