<?php


namespace Juweliere\JuwApiClient\Service;


use Juweliere\JuwApiClient\Constants;
use League\OAuth2\Client\Provider\GenericProvider;
use League\OAuth2\Client\Token\AccessToken;
use League\OAuth2\Client\Token\AccessTokenInterface;
use Predis\Client;
use Psr\Http\Message\RequestInterface;
use Psr\Log\LoggerInterface;

trait ServiceTrait
{
    private GenericProvider $provider;
    protected $baseUrl;
    private Client $redis;
    private LoggerInterface $logger;

    /**
     * ServiceTrait constructor.
     * @param GenericProvider $provider
     * @param $baseUrl
     * @param Client $redis
     * @param LoggerInterface $logger
     */
    public function __construct(GenericProvider $provider, $baseUrl, Client $redis, LoggerInterface $logger)
    {
        $this->provider = $provider;
        $this->baseUrl = $baseUrl . $this->baseUrlResource;
        $this->redis = $redis;
        $this->logger = $logger;
    }

    /**
     * @return AccessToken|AccessTokenInterface
     */
    protected function getAccessToken($force = true)
    {
        $accessToken = $this->redis->get(Constants::KEY_ACCESS_TOKEN);

        if (!$accessToken || $force) {
            try {
                $this->logger->debug("Get new access token");

                $accessToken = $this->provider->getAccessToken('client_credentials');

                $this->redis->set(Constants::KEY_ACCESS_TOKEN, serialize($accessToken));
                $this->redis->expire(Constants::KEY_ACCESS_TOKEN, $accessToken->getExpires());
            } catch (\Throwable $e) {
                $this->logger->error($e->getMessage());
                throw $e;
            }
        } else {
            $accessToken = unserialize($accessToken);
            $this->logger->debug("Use cached token");
        }

        return $accessToken;
    }

    /**
     * @param RequestInterface $request
     * @param $targetObject
     * @return mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    protected function getResponse(RequestInterface $request, $targetObject)
    {
        $result =  $this->provider->getHttpClient()->send($request);

        $data = json_decode((string)$result->getBody());

        $mapper = (new \JsonMapper\JsonMapperFactory())->bestFit();

        if (is_array($data)) {
            foreach ($data as $object) {
                $mapper->mapObject($object, $targetObject);
                $result[] = $targetObject;
            }
        } else {
            $mapper->mapObject($data, $targetObject);
        }

        return $targetObject;
    }
}
