<?php


namespace Juweliere\JuwApiClient\Service;

use Juweliere\JuwApiClient\Entity\Order\Order;
use Juweliere\JuwApiClient\Entity\User;
use Juweliere\JuwApiClient\Entity\User\Login;
use Juweliere\JuwApiClient\Entity\User\Password;
use Juweliere\JuwApiClient\Entity\User\Recovery;
use Juweliere\JuwApiClient\Entity\User\RecoveryToken;

class Users
{
    use ServiceTrait;

    protected $baseUrlResource = "/me/users";

    /**
     * @param Registration $user
     * @return User
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function create(User\Registration $user) {

        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($user)
            ]
        );

        $registerResponse = new User();

        return $this->getResponse($request, $registerResponse);
    }

    /**
     * @param Registration $user
     * @return User
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function get($id) {

        $request =  $this->provider->getAuthenticatedRequest(
            "GET",
            $this->baseUrl . "/" . $id,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ]
            ]
        );

        return $this->getResponse($request, new User());
    }

    /**
     * @param Login $login
     * @return User
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function login(Login $login) {

        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl . "/login",
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($login)
            ]
        );

        $loginResponse = new User();

        return $this->getResponse($request, $loginResponse);
    }

    /**
     * @param Recovery $recovery
     * @return string
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function createRecoveryToken(Recovery $recovery) {

        $request =  $this->provider->getAuthenticatedRequest(
            "POST",
            $this->baseUrl . "/recovery",
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($recovery)
            ]
        );

        $result =  $this->provider->getHttpClient()->send($request);

        $data = json_decode((string)$result->getBody());

        return $data->token;
    }

    /**
     * @param string $userId
     * @param string $password
     * @return User
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @throws \Throwable
     */
    public function recover(string $token, string $password) {

        $request =  $this->provider->getAuthenticatedRequest(
            "PUT",
            $this->baseUrl . "/recovery/" . $token,
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode(array("newPassword" => $password))
            ]
        );

        $recoveryResponse = new User();

        return $this->getResponse($request, $recoveryResponse);
    }



    /**
     * @param RecoveryToken $recovery
     * @return User
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function updatePassword(string $userId, Password $password) {

        $request =  $this->provider->getAuthenticatedRequest(
            "PUT",
            $this->baseUrl . "/" . $userId . "/password",
            $this->getAccessToken(),
            [
                'headers'        => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json'
                ],
                'body' => json_encode($password)
            ]
        );

        $recoveryResponse = new User();

        return $this->getResponse($request, $recoveryResponse);
    }
}
