<?php

namespace Juweliere\JuwApiClient\Entity\Order;


use Juweliere\JuwApiClient\Entity\AbstractEntity;

class Payment extends AbstractEntity
{
    /** @var int */
    protected $id;

    /** @var string */
    protected $type;

    /** @var string */
    protected $externalId;

    /** @var float */
    protected $amount;

    /** @var string */
    protected $data;

    /** @var ?string */
    protected $clientSecret;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getExternalId(): ?string
    {
        return $this->externalId;
    }

    public function setExternalId(?string $externalId): self
    {
        $this->externalId = $externalId;

        return $this;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getData(): ?string
    {
        return $this->data;
    }

    public function setData(?string $data): self
    {
        $this->data = $data;

        return $this;
    }

    /**
     * @return string
     */
    public function getClientSecret(): string
    {
        return $this->clientSecret;
    }

    /**
     * @param string $clientSecret
     */
    public function setClientSecret(string $clientSecret): void
    {
        $this->clientSecret = $clientSecret;
    }
}
